import { Link, useLocation } from 'react-router-dom'
import { Zap } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-creative">
      <header className="header-creative">
        <div className="container">
          <div className="header-content-creative">
            <Link to="/" className="logo-creative">
              <div className="logo-icon-wrapper-creative">
                <Zap className="logo-icon-creative" size={32} />
              </div>
              <span className="logo-text-creative">MARKETZAP</span>
            </Link>
            <nav className="nav-creative">
              <Link 
                to="/" 
                className={`nav-link-creative ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои курсы
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-creative ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-creative">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

